/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.sysutils;

import filenet.vw.sysutils.Registry;
import java.util.Vector;

class testGetRouters {
    private String m_routerNames;
    private String m_routerPorts;
    private String m_routerServiceNames;
    private String m_routerIsolatedRegions;

    protected void printInfo() {
        System.out.println("routerNames=" + this.m_routerNames);
        System.out.println("routerPorts=" + this.m_routerPorts);
        System.out.println("routerServiceNames=" + this.m_routerServiceNames);
        System.out.println("routerIsolatedRegion=" + this.m_routerIsolatedRegions);
    }

    protected testGetRouters(String sRouterHost) {
        int nPortIndex = sRouterHost.indexOf(58);
        int nNameIndex = sRouterHost.indexOf(47);
        String hostName = sRouterHost.substring(0, nPortIndex);
        String routerPort = sRouterHost.substring(nPortIndex + 1, nNameIndex);
        String routerName = sRouterHost.substring(nNameIndex + 1);
        this.retrieveRunningRouters(hostName, routerPort, routerName);
    }

    private void retrieveRunningRouters(String hostName, String routerPort, String routerName) {
        try {
            Registry registry;
            String[] routers;
            if (hostName != null && routerPort != null && (routers = (registry = new Registry()).getRouters(hostName, Integer.parseInt(routerPort), true)) != null && routers.length > 0) {
                String[] routerInfo;
                int i;
                for (i = 0; i < routers.length; ++i) {
                    routerInfo = this.parseString(routers[i]);
                    if (routerInfo == null || routerName.compareTo(routerInfo[0].trim()) != 0) continue;
                    this.m_routerNames = routerInfo[0].trim();
                    this.m_routerPorts = routerInfo[1].trim();
                    this.m_routerServiceNames = routerInfo[2].trim();
                    this.m_routerIsolatedRegions = routerInfo[3].trim();
                    break;
                }
                if (routers.length > 1) {
                    for (i = 0; i < routers.length; ++i) {
                        routerInfo = this.parseString(routers[i]);
                        if (routerInfo == null || routerName.compareTo(routerInfo[0].trim()) == 0) continue;
                        if (this.m_routerNames == null) {
                            this.m_routerNames = routerInfo[0].trim();
                            this.m_routerPorts = routerInfo[1].trim();
                            this.m_routerServiceNames = routerInfo[2].trim();
                            this.m_routerIsolatedRegions = routerInfo[3].trim();
                            continue;
                        }
                        this.m_routerNames = this.m_routerNames + ", " + routerInfo[0].trim();
                        this.m_routerPorts = this.m_routerPorts + ", " + routerInfo[1].trim();
                        this.m_routerServiceNames = this.m_routerServiceNames + ", " + routerInfo[2].trim();
                        this.m_routerIsolatedRegions = this.m_routerIsolatedRegions + ", " + routerInfo[3].trim();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String[] parseString(String sourceStr) {
        try {
            if (sourceStr != null && sourceStr.length() != 0) {
                int nIndex;
                Vector<String> items = new Vector<String>();
                while ((nIndex = sourceStr.indexOf(44)) != -1) {
                    items.addElement(sourceStr.substring(0, nIndex));
                    sourceStr = sourceStr.substring(nIndex + 1);
                }
                if (sourceStr.length() > 0) {
                    items.addElement(sourceStr);
                }
                if (!items.isEmpty()) {
                    Object[] stringArray = new String[items.size()];
                    items.copyInto(stringArray);
                    return stringArray;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

